unit UnitDreiecke;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Math;

type
  TFormDreiecke = class(TForm)
    ImageDreieck: TImage;
    ButtonCount: TButton;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonCountClick(Sender: TObject);
    procedure ImageDreieckMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private-Deklarationen }
    FBuffer: TBitmap;
    FCoords: array of TPoint;
  public
    { Public-Deklarationen }
  end;

var
  FormDreiecke: TFormDreiecke;

implementation

{$R *.dfm}

procedure TFormDreiecke.ImageDreieckMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SetLength(FCoords, Length(FCoords) + 1);
  FCoords[Length(FCoords) - 1] := Point(X, Y);
  ImageDreieck.Canvas.Brush.Color := clRed;
  ImageDreieck.Canvas.Pen.Color := clBlack;
  ImageDreieck.Canvas.Pen.Width := 1;
  ImageDreieck.Canvas.Ellipse(X - 5, Y - 5, X + 6, Y + 6);
end;

procedure TFormDreiecke.ButtonCountClick(Sender: TObject);
var
  I, J, K, Res, CountAll, Count: Integer;
  Angle: Extended;
begin
  CountAll := 0;
  Count := 0;
  for i := 0 to Length(FCoords) - 1 do
  begin
    for j := i + 1 to Length(FCoords) - 1 do
    begin
      for k := j + 1 to Length(FCoords) - 1 do
      begin
        Inc(CountAll);

        Angle := ArcCos((
          (FCoords[i].X - FCoords[k].X) * (FCoords[j].X - FCoords[k].X) +
          (FCoords[i].Y - FCoords[k].Y) * (FCoords[j].Y - FCoords[k].Y)) / (
          Sqrt(Sqr(FCoords[i].X - FCoords[k].X) + Sqr(FCoords[i].Y - FCoords[k].Y)) *
          Sqrt(Sqr(FCoords[j].X - FCoords[k].X) + Sqr(FCoords[j].Y - FCoords[k].Y))));
        Angle := Abs(Angle) * 180 / Pi;
        if (Angle > 90) then Angle := Abs(180 - Angle);
        // Treshold.
        if (Angle < 10) then Continue;

        {
  			if (ArcCos(
          ((FCoords[i].X - FCoords[j].X) *
          (FCoords[i].X - FCoords[k].X) +
          (FCoords[i].Y - FCoords[j].Y) *
          (FCoords[i].Y - FCoords[k].Y)) /
  				((Sqrt(Sqr(FCoords[i].X - FCoords[j].X) +
          Sqr(FCoords[i].Y - FCoords[j].Y))) *
          Sqrt(Sqr(FCoords[i].X - FCoords[k].X) +
          Sqr(FCoords[i].Y - FCoords[k].Y))))
          > Pi * 100 / 180) then
        }

        ImageDreieck.Canvas.Brush.Color := clWhite;
        ImageDreieck.Canvas.FillRect(ClientRect);
        ImageDreieck.Canvas.Draw(0, 0, FBuffer);
        ImageDreieck.Canvas.Pen.Color := clAqua;
        ImageDreieck.Canvas.Pen.Width := 5;
        ImageDreieck.Canvas.Pen.Mode := pmXor;
        ImageDreieck.Canvas.MoveTo(FCoords[i].X, FCoords[i].Y);
        ImageDreieck.Canvas.LineTo(FCoords[j].X, FCoords[j].Y);
        ImageDreieck.Canvas.LineTo(FCoords[k].X, FCoords[k].Y);
        ImageDreieck.Canvas.LineTo(FCoords[i].X, FCoords[i].Y);

        ImageDreieck.Canvas.Brush.Color := clRed;
        ImageDreieck.Canvas.Pen.Color := clBlack;
        ImageDreieck.Canvas.Pen.Width := 1;
        ImageDreieck.Canvas.Pen.Mode := pmCopy;
        ImageDreieck.Canvas.Ellipse(FCoords[i].X - 5, FCoords[i].Y - 5,
          FCoords[i].X + 6, FCoords[i].Y + 6);
        ImageDreieck.Canvas.Ellipse(FCoords[j].X - 5, FCoords[j].Y - 5,
          FCoords[j].X + 6, FCoords[j].Y + 6);
        ImageDreieck.Canvas.Ellipse(FCoords[k].X - 5, FCoords[k].Y - 5,
          FCoords[k].X + 6, FCoords[k].Y + 6);

        ImageDreieck.Canvas.Brush.Color := clWhite;
        ImageDreieck.Canvas.Font := Self.Font;
        ImageDreieck.Canvas.TextOut(8, 4, IntToStr(Count) + ' von ' + IntToStr(CountAll));
        //- ImageDreieck.Canvas.TextOut(8, 24, FloatToStr(Angle));

        Res := MessageDlg('Ist das ein Dreieck?', Dialogs.mtConfirmation,
          Dialogs.mbYesNoCancel, 0);
        if (Res = mrCancel) then Exit;
        if (Res = mrYes) then Inc(Count);
        ImageDreieck.Canvas.TextOut(8, 4, IntToStr(Count) + ' von ' + IntToStr(CountAll));
      end;
    end;
  end;
end;

procedure TFormDreiecke.FormCreate(Sender: TObject);
begin
  FBuffer := TBitmap.Create();
  if (FileExists(ExtractFilePath(Application.EXEName) + 'Dreiecke.bmp')) then
  begin
    FBuffer.LoadFromFile(ExtractFilePath(Application.EXEName) + 'Dreiecke.bmp');
    Self.ClientWidth := FBuffer.Width;
    Self.ClientHeight := FBuffer.Height;
    ImageDreieck.Canvas.Draw(0, 0, FBuffer);
  end;
end;

procedure TFormDreiecke.FormDestroy(Sender: TObject);
begin
  FBuffer.Free();
end;

end.
